﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CoinScript : MonoBehaviour {

    public static CoinScript instance;

    public float coinSpeed = 15f;

    public Vector2 coinDirection;

    bool isReady;

    void Awake() {
        isReady = false;
    }


    void Start () {
        MakeInstance();
	}

    void MakeInstance() {
        if (instance == null) {
            instance = this;
        }
    }

    void Update () {
        if (isReady) {
            Vector2 position = transform.position;
            position += coinDirection * coinSpeed * Time.deltaTime;
            transform.position = position;
        }
	}

    public void SetCoinDirection(Vector2 direction) {
        coinDirection = direction.normalized;
        isReady = true;
    }
}
